--[[
    AttacherJointUtil.lua

    Extends the SpecializationUtil to allow more operations on eventListeneres

	@author: 		BayernGamers
	@date: 			05.12.2025
	@version:		1.0

	History:		v1.0 @05.12.2025 - initial implementation in FS25
                    ------------------------------------------------------------------------------------------------------

	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage:
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
                        Non-Compete:
                            This script may not be used in any scripts or mods that can be considered to be a direct competitor to the mod this script is part of.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
AttacherJointUtil = {}

function AttacherJointUtil.getUsesFrontloaderToolAttacher(info, checkUsesQuickConnector)
    if info ~= nil then
        local attachable = info.attachable
        local attacherVehicle = info.attacherVehicle
        local attachableJointDescIndex = info.attachableJointDescIndex
        local attacherVehicleJointDescIndex = info.attacherVehicleJointDescIndex

        if attachable ~= nil and attacherVehicle ~= nil and attachableJointDescIndex ~= nil and attacherVehicleJointDescIndex ~= nil then
            local attacherJoint = attacherVehicle:getAttacherJointByJointDescIndex(attacherVehicleJointDescIndex)
            local attachableJoint = attachable:getInputAttacherJointByJointDescIndex(attachableJointDescIndex)

            local frontLoaderAttacherTypeConfig = attacherVehicle.configurations["frontloaderAttacherType"]

            if frontLoaderAttacherTypeConfig ~= nil then
                if checkUsesQuickConnector and frontLoaderAttacherTypeConfig < 3 then
                    return false
                end

                if frontLoaderAttacherTypeConfig == 1 then
                    return false
                end
            end

            if attacherJoint ~= nil and attachableJoint ~= nil then
                local usesFrontloaderToolAttacher = attacherJoint.jointType == AttacherJoints.JOINTTYPE_FRONTLOADER and attachableJoint.jointType == AttacherJoints.JOINTTYPE_FRONTLOADER
                local usesTelehandlerToolAttacher = attacherJoint.jointType == AttacherJoints.JOINTTYPE_TELEHANDLER and attachableJoint.jointType == AttacherJoints.JOINTTYPE_TELEHANDLER
                local usesWheelLoaderToolAttacher = attacherJoint.jointType == AttacherJoints.JOINTTYPE_WHEELLOADER and attachableJoint.jointType == AttacherJoints.JOINTTYPE_WHEELLOADER
                --local usesBigBagAttacher = attacherJoint.jointType == AttacherJoints.JOINTTYPE_BIGBAG and attachableJoint.jointType == AttacherJoints.JOINTTYPE_BIGBAG
                --local usesHookliftAttacher = attacherJoint.jointType == AttacherJoints.JOINTTYPE_HOOKLIFT and attachableJoint.jointType == AttacherJoints.JOINTTYPE_HOOKLIFT
                return usesFrontloaderToolAttacher or usesTelehandlerToolAttacher or usesWheelLoaderToolAttacher --or usesBigBagAttacher or usesHookliftAttacher
            end
        end
    end

    return false
end

function AttacherJointUtil.getUsesHookLiftAttacher(info)
    if info ~= nil then
        local attachable = info.attachable
        local attacherVehicle = info.attacherVehicle
        local attachableJointDescIndex = info.attachableJointDescIndex
        local attacherVehicleJointDescIndex = info.attacherVehicleJointDescIndex

        if attachable ~= nil and attacherVehicle ~= nil and attachableJointDescIndex ~= nil and attacherVehicleJointDescIndex ~= nil then
            local attacherJoint = attacherVehicle:getAttacherJointByJointDescIndex(attacherVehicleJointDescIndex)
            local attachableJoint = attachable:getInputAttacherJointByJointDescIndex(attachableJointDescIndex)

            if attacherJoint ~= nil and attachableJoint ~= nil then
                local usesHookliftAttacher = attacherJoint.jointType == AttacherJoints.JOINTTYPE_HOOKLIFT and attachableJoint.jointType == AttacherJoints.JOINTTYPE_HOOKLIFT
                return usesHookliftAttacher
            end
        end
    end

    return false
end

function AttacherJointUtil.getUsesBigBagAttacher(info)
    if info ~= nil then
        local attachable = info.attachable
        local attacherVehicle = info.attacherVehicle
        local attachableJointDescIndex = info.attachableJointDescIndex
        local attacherVehicleJointDescIndex = info.attacherVehicleJointDescIndex

        if attachable ~= nil and attacherVehicle ~= nil and attachableJointDescIndex ~= nil and attacherVehicleJointDescIndex ~= nil then
            local attacherJoint = attacherVehicle:getAttacherJointByJointDescIndex(attacherVehicleJointDescIndex)
            local attachableJoint = attachable:getInputAttacherJointByJointDescIndex(attachableJointDescIndex)

            if attacherJoint ~= nil and attachableJoint ~= nil then
                local usesBigBagAttacher = attacherJoint.jointType == AttacherJoints.JOINTTYPE_BIGBAG and attachableJoint.jointType == AttacherJoints.JOINTTYPE_BIGBAG
                return usesBigBagAttacher
            end
        end
    end

    return false
end

function AttacherJointUtil.getAllowsAttachFromInside(info)
    if info ~= nil then
        local attachable = info.attachable
        local attacherVehicle = info.attacherVehicle
        local attachableJointDescIndex = info.attachableJointDescIndex
        local attacherVehicleJointDescIndex = info.attacherVehicleJointDescIndex

        if attachable ~= nil and attacherVehicle ~= nil and attachableJointDescIndex ~= nil and attacherVehicleJointDescIndex ~= nil then
            local attacherJoint = attacherVehicle:getAttacherJointByJointDescIndex(attacherVehicleJointDescIndex)
            local attachableJoint = attachable:getInputAttacherJointByJointDescIndex(attachableJointDescIndex)

            if attacherJoint ~= nil and attachableJoint ~= nil then
                if attachableJoint.allowAttachFromInside then
                    return true
                end
            end
        end
    end
end

function AttacherJointUtil.getAttachHosesIfAttachedFromInside(info)
	if info ~= nil then
		local attachable = info.attachable
		local attacherVehicle = info.attacherVehicle
		local attachableJointDescIndex = info.attachableJointDescIndex
		local attacherVehicleJointDescIndex = info.attacherVehicleJointDescIndex

		if attachable ~= nil and attacherVehicle ~= nil and attachableJointDescIndex ~= nil and attacherVehicleJointDescIndex ~= nil then
			local attacherJoint = attacherVehicle:getAttacherJointByJointDescIndex(attacherVehicleJointDescIndex)
			local attachableJoint = attachable:getInputAttacherJointByJointDescIndex(attachableJointDescIndex)

			if attacherJoint ~= nil and attachableJoint ~= nil then
				if attachableJoint.attachHosesIfAttachedFromInside then
					return AttacherJointUtil.getAllowsAttachFromInside(info)
				end
			end
		end
	end
end

function AttacherJointUtil.getAttachPTOIfAttachedFromInside(info)
	if info ~= nil then
		local attachable = info.attachable
		local attacherVehicle = info.attacherVehicle
		local attachableJointDescIndex = info.attachableJointDescIndex
		local attacherVehicleJointDescIndex = info.attacherVehicleJointDescIndex

		if attachable ~= nil and attacherVehicle ~= nil and attachableJointDescIndex ~= nil and attacherVehicleJointDescIndex ~= nil then
			local attacherJoint = attacherVehicle:getAttacherJointByJointDescIndex(attacherVehicleJointDescIndex)
			local attachableJoint = attachable:getInputAttacherJointByJointDescIndex(attachableJointDescIndex)

			if attacherJoint ~= nil and attachableJoint ~= nil then
				if attachableJoint.attachPTOIfAttachedFromInside then
					return AttacherJointUtil.getAllowsAttachFromInside(info)
				end
			end
		end
	end
end