----------------------------------------------------------------------------
-- @Author: ViperGTS96------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

growNow = {};
local modDescFile = loadXMLFile("modDesc", g_currentModDirectory.."modDesc.xml");
growNow.title = getXMLString(modDescFile, "modDesc.title.en");
growNow.author = getXMLString(modDescFile, "modDesc.author");
growNow.version = getXMLString(modDescFile, "modDesc.version");
delete(modDescFile);

function growNow:loadMap(savegame)
	if g_currentMission:getIsClient() then
		growNow.events = {};
		PlayerInputComponent.registerGlobalPlayerActionEvents = Utils.appendedFunction(PlayerInputComponent.registerGlobalPlayerActionEvents, growNow.registerActionEvents);
		PlayerInputComponent.unregisterActionEvents = Utils.appendedFunction(PlayerInputComponent.unregisterActionEvents, growNow.unregisterActionEvents);
		Enterable.onRegisterActionEvents = Utils.appendedFunction(Enterable.onRegisterActionEvents, growNow.registerActionEvents);
	end;
end;

function growNow:unregisterActionEvents()
	if self.player.isClient then
		g_inputBinding:removeActionEvent(growNow.events[1]);
		growNow.events = {};
	end;
end;

function growNow:registerActionEvents()
local isClient = self.isClient;
	if isClient == nil then
		isClient = self.player ~= nil and self.player.isClient;
	end;
	if isClient then
		growNow.events = {};
		local valid, eventId = g_inputBinding:registerActionEvent(InputAction.growCrops_Key, InputBinding.NO_EVENT_TARGET, growNow.growCrops, false, true, false, true);
		if valid then
			table.insert(growNow.events, eventId);
			g_inputBinding:setActionEventText(eventId, g_i18n:getText("input_growCrops_Key"));
			g_inputBinding:setActionEventTextVisibility(eventId, true);
			g_inputBinding:setActionEventTextPriority(eventId, GS_PRIO_VERYLOW);
		end;
	end;
end;

function growNow:growCrops(actionName, keyStatus, arg3, arg4, arg5)
	if actionName == "growCrops_Key" then
		growNow:sendGrowNowEvent(true);
	end;
end;

function growNow:sendGrowNowEvent(grow, noEventSend)
	growNowEvent.sendEvent(grow, noEventSend);
	if grow then
		if g_currentMission.missionInfo.growthMode ~= 2 then
			g_currentMission:setGrowthMode(2);
		end;
		g_currentMission.growthSystem:triggerGrowth(1);--1-12
	end;
end;

addModEventListener(growNow);

print(growNow.title.." : v"..growNow.version.." by "..growNow.author.." activated");

growNowEvent = {};
growNowEvent_mt = Class(growNowEvent, Event);
InitEventClass(growNowEvent,"growNowEvent");

function growNowEvent:emptyNew()
    local self = Event.new(growNowEvent_mt);
    self.className = "growNowEvent";
    return self;
end;
function growNowEvent:new(state)
	local self = growNowEvent.emptyNew()
    self.state = state;
    return self;
end;
function growNowEvent:readStream(streamId,connection)
    self.state = streamReadBool(streamId);
    self:run(connection);
end;
function growNowEvent:writeStream(streamId,connection)
    streamWriteBool(streamId,self.state);
end;
function growNowEvent:run(connection)
    growNow:sendGrowNowEvent(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(growNowEvent:new(self.state),nil,connection);
    end;
end;
function growNowEvent.sendEvent(state,noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(growNowEvent:new(state));
        else
            g_client:getServerConnection():sendEvent(growNowEvent:new(state));
        end;
    end;
end;